/*
    SPDX-FileCopyrightText: 2014-2023 Anne Jan Brouwer <brouwer@annejan.com>
    SPDX-FileCopyrightText: 2018 Lukas Vogel <lukedirtwalker@gmail.com>
    SPDX-FileCopyrightText: 2018 Claudio Maradonna <penguyman@stronzi.org>
    SPDX-FileCopyrightText: 2023 g10 Code GmbH
    SPDX-FileContributor: Sune Stolborg Vuorela <sune@vuorela.dk>

    SPDX-License-Identifier: GPL-3.0-or-later
*/
#ifndef PASSWORDDIALOG_H_
#define PASSWORDDIALOG_H_

#include "passentry.h"
#include "passwordconfiguration.h"
#include <QDialog>

namespace Ui
{
class PasswordDialog;
}

class QLineEdit;

/*!
    \class PasswordDialog
    \brief PasswordDialog Handles the inserting and editing of passwords.

    Includes templated views.
 */
class PasswordDialog : public QDialog
{
    Q_OBJECT

public:
    explicit PasswordDialog(const PassEntry &passEntry, const PasswordConfiguration &passConfig, QWidget *parent = nullptr);
    ~PasswordDialog() override;

    /*! Sets content in the template for the interface.
        \param rawFields is the template as a QString
        \param useTemplate whether the template is used
     */
    void setTemplate(const QString &rawFields, bool useTemplate);

    void templateAll(bool templateAll);
    void setLength(int l);
    void setPasswordCharTemplate(int t);

    void accept() override;

Q_SIGNALS:
    void save(const QString &content);

private Q_SLOTS:
    void createPassword();
    void togglePasswordGenerationOption(bool checked);

private:
    void load();

    QString toRawContent() const;

    std::unique_ptr<Ui::PasswordDialog> ui;
    PassEntry m_passEntry;
    PasswordConfiguration m_passConfig;
    QStringList m_fields;
    bool m_templating;
    bool m_allFields;
    QList<QLineEdit *> templateLines;
    QList<QLineEdit *> otherLines;
};

#endif // PASSWORDDIALOG_H_
