// SPDX-FileCopyrightText: 2024 g10 Code GmbH
// SPDX-FileContributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-3.0-or-later

#include "settings.h"
#include "setupenv.h"
#include "userslistmodel.h"
#include <QAbstractItemModelTester>
#include <QObject>
#include <QSignalSpy>
#include <QTest>

using namespace Qt::StringLiterals;

class UsersListModelTest : public QObject
{
    Q_OBJECT

private Q_SLOTS:
    void initTestCase();
    void testModel();
};

void UsersListModelTest::initTestCase()
{
    Test::setupEnv();
}

void UsersListModelTest::testModel()
{
    Settings::setPassStore(QString::fromLatin1(DATA_DIR));
    auto model = new UsersListModel(QString::fromLatin1(DATA_DIR) + u"/hello", this);
    auto tester = new QAbstractItemModelTester(model);
    Q_UNUSED(tester);
    QSignalSpy spy(model, &UsersListModel::finishedKeysFetching);
    spy.wait();
    QCOMPARE(model->rowCount({}), 5);

    // valid key with secrets
    QCOMPARE(model->data(model->index(0, 0), Qt::DisplayRole).toString(),
             u"unittest key (no password) <test@kolab.org>\n8D9860C58F246DE6 created 11/13/09 5:33\u202FPM"_s);
    QCOMPARE(model->data(model->index(0, 0), UsersListModel::NameRole).toString(), u"unittest key (no password) <test@kolab.org>"_s);
    QCOMPARE(model->data(model->index(0, 0), Qt::CheckStateRole).value<Qt::CheckState>(), Qt::Unchecked);
    QCOMPARE(model->data(model->index(0, 0), Qt::UserRole).value<UserInfo>().have_secret, true);
    QCOMPARE(model->data(model->index(0, 0), Qt::ForegroundRole).value<QColor>(), Qt::blue);
    QCOMPARE(model->data(model->index(0, 0), Qt::FontRole).value<QFont>().bold(), 1);

    // no secret
    QCOMPARE(model->data(model->index(2, 0), UsersListModel::NameRole).toString(), u"Leonardo Franchi (lfranchi) <lfranchi@kde.org>"_s);
    QCOMPARE(model->data(model->index(2, 0), Qt::UserRole).value<UserInfo>().have_secret, false);
    QCOMPARE(model->data(model->index(2, 0), Qt::ForegroundRole).value<QColor>(), Qt::white);
}

QTEST_MAIN(UsersListModelTest)
#include "tst_userslistmodel.moc"