// SPDX-FileCopyrightText: 2023 g10 code Gmbh
// SPDX-Contributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#include "composerwindowfactory.h"
#include "editor/composerwindow.h"

ComposerWindowFactory::ComposerWindowFactory() = default;

ComposerWindowFactory &ComposerWindowFactory::self()
{
    static ComposerWindowFactory instance;
    return instance;
}

ComposerWindow *ComposerWindowFactory::create(const QString &fromAddress, const QString &name, const QByteArray &bearerToken)
{
    if (inactiveWindow) {
        auto window = inactiveWindow;
        inactiveWindow = nullptr;
        window->reset(fromAddress, name, bearerToken);
        return window;
    }

    return new ComposerWindow(fromAddress, name, bearerToken);
}

void ComposerWindowFactory::clear(ComposerWindow *composerWindow)
{
    auto close = composerWindow->queryClose();
    if (!close) {
        return;
    }

    if (inactiveWindow) {
        composerWindow->deleteLater();
        return;
    }

    inactiveWindow = composerWindow;
    inactiveWindow->hide();
}
