//------------------------------ $Keywords ----------------------------------
// GPGee - GNU Privacy Guard Explorer Extension
// GPGee.cpp - Project source - framework for the .dll
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of GPGee.
//
// GPGee is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// GPGee is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// VCS: $Version: 1 $ $Revision: 4 $
/*
$History: **** V 1.0 by kfitzner ****
$History: * gpgee.cpp - 2005-05-13 11:14:14 PM - 7604 Bytes
$History: * Initial check-in
$History: **** V 1.1 by kfitzner ****
$History: * gpgee.cpp - 2005-05-17 2:14:15 AM - 7840 Bytes
$History: * Add persistent key cache
$History: **** V 1.2 by kfitzner ****
$History: * gpgee.cpp - 2005-08-08 6:45:32 AM - 7945 Bytes
$History: * License change - remove option for later versions of GPL
$History: **** V 1.3 by kfitzner ****
$History: * gpgee.cpp - 2005-08-31 8:42:42 PM - 8144 Bytes
$History: * Update packages
$History: **** Latest ** V 1.4 by kfitzner ** 2005-09-06 6:41:34 AM ****
$History: * Semi-permanent check-out - checked in for 1.2.0
*/
//----------------------------  $NoKeywords ---------------------------------


//---------------------------------------------------------------------------
// File Notes:
//---------------------------------------------------------------------------
// 21 Mar 2005 - Kurt Fitzner <kfitzner@excelcia.org>
//
// This is the project source file.  It is the basic framework for the DLL.
// It was originally generated by C++ Builder, but has had some code added
// to DLLEntryPoint() to set things up better.
//---------------------------------------------------------------------------

//$$---- axlib proj source ---- (stAXLibProjectSource)
#include <vcl.h>
#pragma hdrstop
#include <atl\atlvcl.h>

#include "gpgme/gpgme.h"
#include "TConfiguration.h"
#include "TProgramLog.h"
#include "GPGeeUtility.h"
#include "GPGeeContextMenuExtensionImpl.h"
USEFORM("GPGeeSignEncrypt.cpp", formGPGeeSignEncrypt);
USEFORM("GPGeeVerifyDecrypt.cpp", formGPGeeVerifyDecrypt);
USEFORM("GPGeePassPhrase.cpp", formGPGeePassPhrase);
USEFORM("GPGeeConfigure.cpp", formGPGeeConfigure);
USEFORM("GPGeeNewVersionNotify.cpp", formGPGeeNewVersionNotify);
USEFORM("TProgressForm.cpp", ProgressForm);
//---------------------------------------------------------------------------
#pragma package(smart_init)
TComModule  GPGeeModule;
TComModule &_Module = GPGeeModule;
TConfiguration *GPGeeConfig = NULL;
TProgramLog *Log = NULL;
TStringList *PassphraseCache;
AnsiString sBinDir;

//---------------------------------------------------------------------------
// The ATL Object map holds an array of _ATL_OBJMAP_ENTRY structures that
// described the objects of your OLE server. The MAP is handed to your
// project's CComModule-derived _Module object via the Init method.
//
BEGIN_OBJECT_MAP(ObjectMap)
  OBJECT_ENTRY(CLSID_GPGeeContextMenuExtension, TGPGeeContextMenuExtensionImpl)
END_OBJECT_MAP()
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Entry point of your Server invoked by Windows for processes or threads are
// initialized or terminated.
//
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void*)
{
  static HWND Handle;
  char *buffer;
  HINSTANCE res;

  switch (reason) {
    case DLL_PROCESS_ATTACH:
      _Module.Init(ObjectMap, hinst);
      DisableThreadLibraryCalls(hinst);

      Handle = Application->Handle;             // Fix the Application->Handle - give it the handle of the host application
      Application->Handle = GetActiveWindow();
      Application->Name = "GPGee";

      buffer = (char *)SysGetMem(MAXPATH);     // Find where the module is sitting and use that as the directory for where the help file is too.
      if (!GetModuleFileName(HInstance, buffer, MAXPATH))
        sBinDir = "";
      else
        sBinDir = ExtractFileDir(buffer);
      SysFreeMem(buffer);

      // LOGGING - the following statement initializes the log.  In addition to this, logging must be enabled either
      // by turning on debugging mode, or by #define-ing ENABLE_LOGGING.  If this is not done, then all the log macros
      // will expand to nothing.
      // Set the logging level in the last parameter below - see TProgramLog.h for all the log levels.
      Log = NEWLOG(sBinDir + "\\GPGee.log", true, false, LOG_STRUCTURE);
      __ENTERPROGRAM__;
      Application->HelpFile = sBinDir + "\\GPGee.hlp";

      GPGeeConfig = new TConfiguration();       // Load the configuration

      // Initialize the passphrase cache
      PassphraseCache = new TStringList;

      // Check to see if upgrading needs doing (to the registry, etc) for when we are converting to a new version
      Upgrade();

      LOG(LOG_MESSAGE, "Initializing GPGME library.");
      gpgme_lib_init();                         // Set up the gpgme library
      break;

    case DLL_THREAD_ATTACH:
    case DLL_THREAD_DETACH:
      break;

    case DLL_PROCESS_DETACH:
      Application->Handle = Handle;             // Restore the Application->Handle
      if (GPGeeConfig)                          // Delete the configuration object
        delete GPGeeConfig;
      LOG(LOG_MESSAGE, "Cleaning up GPGME library.");
      CleanupKeyCaches();
      gpgme_lib_cleanup();                      // Clean up the gpgme library
      __LEAVEPROGRAM__;
      delete Log;
      break;
  }  // switch (reason)
  return TRUE;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// _Module.Term is typically invoked from the DLL_PROCESS_DETACH of your
// DllEntryPoint. However, this may result in an incorrect shutdown sequence.
// Instead an Exit routine is setup to invoke the cleanup routine
// CComModule::Term.
//
void ModuleTerm(void)
{
    _Module.Term();
}
#pragma exit ModuleTerm 63
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Entry point of your Server invoked to inquire whether the DLL is no
// longer in use and should be unloaded.
//
STDAPI __export DllCanUnloadNow(void)
{
    return (_Module.GetLockCount()==0) ? S_OK : S_FALSE;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Entry point of your Server allowing OLE to retrieve a class object from
// your Server
//
STDAPI __export DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
    return _Module.GetClassObject(rclsid, riid, ppv);
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Entry point of your Server invoked to instruct the server to create
// registry entries for all classes supported by the module
//
STDAPI __export DllRegisterServer(void)
{
    return _Module.RegisterServer(TRUE);
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Entry point of your Server invoked to instruct the server to remove
// all registry entries created through DllRegisterServer.
//
STDAPI __export DllUnregisterServer(void)
{
    return _Module.UnregisterServer();
}
//---------------------------------------------------------------------------
