static char client_cert_repro_pem[] =
	"-----BEGIN CERTIFICATE-----\n"
	"MIILITCCBiegAwIBAgIJAMHDrh3rcjmCMA0GCSqGSIb3DQEBCwUAMEUxCzAJBgNV\n"
	"BAYTAkFVMRMwEQYDVQQIDApTb21lLVN0YXRlMSEwHwYDVQQKDBhJbnRlcm5ldCBX\n"
	"aWRnaXRzIFB0eSBMdGQwHhcNMTcwOTEzMDkzOTE1WhcNMTcwOTE0MDkzOTE1WjBF\n"
	"MQswCQYDVQQGEwJBVTETMBEGA1UECAwKU29tZS1TdGF0ZTEhMB8GA1UECgwYSW50\n"
	"ZXJuZXQgV2lkZ2l0cyBQdHkgTHRkMIIFBDANBgkqhkiG9w0BAQEFAAOCBPEAMIIE\n"
	"7AKCBOMAxa5Is252x+Q0JMEZoU2DTZVqTPQMFfkv9bLjFCrbtUQCjEB187oPh9HE\n"
	"vEqkuC5hVl2H+kPa7u2sYrthPNCdMXd/kVAmSE9iS7sKuV8Z9UERHerP0tp06948\n"
	"WpsuDe4iUsKzDLkQwT3x3pnzj0f7WjQkLBx7nr533JEoKpU0Kq6Zh5UHSapJdZ8j\n"
	"0y6sAZ9QDYIHvBkXM+L6gsZUOV7dqE5+71e+o+upUZoRkpwowckIjvttCKmoaUSf\n"
	"swBm8p9c/8Gwaw+TW90/NiAgjllcu+ON0cFEG/OecmtnfYpIzF14M8eW2QjOA7K5\n"
	"1PP2EIYM6sJzZ6EUnCUkLHg8tVyluGNIU+0/pcCK3PK0APahKCLQy0KINcYS8omP\n"
	"HUgiXWZLns2WrvJinkhcDqDhIDd5F3cGLdzaps5NKmgRNpZJFGC4qAOj0MFqkU+3\n"
	"Lyq81fEKcmrhsATjVptvNDp3/gFiJqNry0YCmS3QnbokugCKPeWcJZyXf9QzVlC/\n"
	"NGZGQXN0ncMUkCDEbQcsbYz079Tu4h+/PMFrIoFTqc4DnwbTNOpgnlMHdOZIhwl5\n"
	"2lSRjnp/VjyJePpj3Z17eVboVZPs2qcukdCtjUPBZ8+ycIVeDf8aHtu69duS0nCI\n"
	"D3zXb7vOtdqcQ4tHY/SmNEVK2wAXZh0e2TUM2PT3OpCce/TBf+u2Rh9t9btv75XI\n"
	"8QbY68SlZUTnFZELsE7IPDgdwIERXiIOMfmTL6XNBAkmWEsVQBfHiP55d5B4b/3p\n"
	"niQ3RhBr0X8pYh8m0HAZyFGKIU/8egHPEH6EVFQlbzmG/ubNb8JGNwfiATjbr6BW\n"
	"L/aF/4lxqL1/gOQ9dtZvK4tys5dIXcSN//CRE/rhUCCl+kg7DuXd9h/xg1QcnnkI\n"
	"GymUb67lNFXZx/all9H08ApB9ldufcwaFvWhc37sGWTnaLpEnxNNqlPAr9G9BHZA\n"
	"tUezrGSx7+YRJKH61xevuomTeMX+T1HlO/YSKoX2R3Qk9ClWQzrT73cCYhEai5bD\n"
	"FO9MX00hRUfXBKl2u8GEzMzwN/1oSWuXMYQbW5NP+UAchBi82ihR2zg2S+Wzl4NC\n"
	"Wr7vjwNXaj0e1UKwCxk2ypGx7dX/URe9skttZgr9va8NrW6aNokiTgG6BKq4sfjv\n"
	"bqZ3+uAiPg6QnnjLEGizfVGno4+ufky3y5yc3MIgLvrxo8IhHp7iXqf5ebPBdyYo\n"
	"BuAhERp7CDBcIDoOFW2xyljwTwpadMCmC2rmJmuwNvxKT1r9EZ/jiqwiVw8zuhYc\n"
	"P0LTM5B+OlDrOFVBW9zRF4lSKX30/cR7XaPlGS6WbYTsuuJeUnWsS42jrQiOQH88\n"
	"x4zrLcqwkchLl5SBw6ywS0RAszBI8OkHzFmbBIr6Q0vgmfy+ugd6ssv5Ec8Imfg1\n"
	"UQdBWclzgWppb8JFBTjY8keqt9bgVfZfV+cOjuMTqOdHP/eu4n2h/6fECwd4sk12\n"
	"fyesKgVbtMkMXOkTUCeGIstsrvRX7BAupRISXbl+gAK/Ew0kB4YioXI51FNVO7eI\n"
	"kEkZIdWLfr9J2iSxiOuOlghYc4v+CJOFW6/DIBhK96Ih0ygteztuJ4D+GBXXx7h4\n"
	"mHygdAk6zPQtZ+nbz9qPOl0rS3F6XOmR7GgcXX6Zxfpj4Afd/7XFR3IntqlHbqNv\n"
	"SkkZcIpiiwkCAwEAAaNQME4wHQYDVR0OBBYEFPfXnI4wJZG2AzoMj5AbZHoiTHp9\n"
	"MB8GA1UdIwQYMBaAFPfXnI4wJZG2AzoMj5AbZHoiTHp9MAwGA1UdEwQFMAMBAf8w\n"
	"DQYJKoZIhvcNAQELBQADggTjACd/BFFw29X5lkQA+o+NqQlkoKhFMjReZgkt9ou8\n"
	"zSEhAbbrVMdljUjRAbs0FevIV23MJRv4st//JWl/H/OcUHYfHwTkYD0SZNJ2BDvM\n"
	"9K4ItGvwBlYilPxcwQmFCErjJuI164bXDHWEcc69XXK9cfKhV4g8JxEQptE5mHPi\n"
	"RcFCvN+Z2h80+c+M6xUGHRUIUHLdih9pOimhwT8msKcLBT3IcFcaBj8KO2Lr6aLK\n"
	"/rADUMObkfBF1rMMOUo07GX/bJjt7V4Jj7v7G9OhIh+//a9LVE8sYWzoqAf/hBDE\n"
	"vrX/5JRToUIQl6bxaVyDnCGdrUh9qfiRC3sNVKnWksGdPked2V2hUonr2UZZy4E4\n"
	"feDcICkeZ9cUvIBmi+oPfWJnQ7Hb3HBToZG4lvsO1EIRJDNv3vXz9HcRFNNkvLE4\n"
	"Xidvs/v1e2nTemGFzDyV1hUIevXza4eydgFDrjhWdHFj6HMNaJ0WXINBQ4Vl9AW0\n"
	"X3BuPZC9TbLQlUKfJz9GdRjuj9eQtA0pEeToB6ySYePeyQmqTEdO9ufYoa1L0Sdt\n"
	"ueOGqQW9BD55sb2lbh53TsyHPgklYKYJ/fJd6Df1ox4DIeFZ/sCTp7GMtgPizcA0\n"
	"OYOtamtFL3upLQsr8hu1NWmdX3/qXYUycpt0W0g4F3bKILk6O4gqNYA7AOEWPY7B\n"
	"hRD84fU3jHjDfAc2TbL/Zc/54F33SM/NA1WmkYKThlTRy2VQ7yhZKkiluapQ94BL\n"
	"umMfyRPSUSNnWJzPLKoZ7701pR2Pc0AWY15zcCuUsNtB1vAnmAeOggBvzwc4xshc\n"
	"g1E/VSYXID0Fmn0IF4ZLJdOK8pA9ae5dGj2kmk8Spw/wSSHe+dGDL708L2/q19Za\n"
	"rtDOAXLTzjUB/tinQuEk27LhrVKV7TY5mS/HR22glH8PVIZ2X86+9Ad/d2CqWJSV\n"
	"ukuuXfzsUuO2ElDz74dH9U7jOYsulo0/0OKR9pjVmmDtAji+Hc1TlSjEOKyuCfqI\n"
	"7A+3SorkrEFqWxmOb9Kv2Z+hE/+RF80k3CvNfD8taxIkGUyj8dSlytMitnzS/PA4\n"
	"6EwE2Vxsm39CvcWgqSTAaYzC5pLZy3W5ATna0gU6em8bMpliNo4HrIKB6c27/ScY\n"
	"OTYc0DK/cpREOFxz3C20agiRVCn7Vt+vdnBqh4yj/l5hhrlZXrn0iDyr67g5E8iL\n"
	"enXeGhuOzIJw70OfB/WdVXkmopgBm9J0yVgL7UR8uN0Y5SQCy/4L26YOdxk/fmbE\n"
	"bGfsS2AvFZZ4dP0hYmHQO2F0UfQ1iYe9R/cF6TqhtRLuVAXz9wbwNf+pCjJuhg91\n"
	"WY9Lpo5onkoUal4e325xAASnsWAMoFnpS+D/VOPmOuWmnjAj8001ueXFCPKb8VK0\n"
	"G1dxTZrZs0KPi4xrLSF/5L6n5H7VM6yRnX1BUun96lBzV45P3rAhCy+7r6IHMAqJ\n"
	"VuM0+G/s9ZHRnmm3RwM4ufRGF+uSVzcBaVB0iPTXKWPDizBTgowa2CqVGmFalEIm\n"
	"XPWqyhXwgctDCre4P0QYKSqoSaZ0aQaoPGZ10K3m12Pq69gmi6aRKhse7MkfQtho\n"
	"+3Gix3f5m0hgDjp/v3UApfP+bAObOODGG+MhJJOBJlmZE/B1jwyJpV/YjHi2VRsm\n"
	"GkcJOt7A+6vGf1zPNNoB+/fAd6B+\n"
	"-----END CERTIFICATE-----\n";

static char client_key_repro_pem[] =
	"-----BEGIN PRIVATE KEY-----\n"
	"MIIWOwIBADANBgkqhkiG9w0BAQEFAASCFiUwghYhAgEAAoIE4wDFrkizbnbH5DQk\n"
	"wRmhTYNNlWpM9AwV+S/1suMUKtu1RAKMQHXzug+H0cS8SqS4LmFWXYf6Q9ru7axi\n"
	"u2E80J0xd3+RUCZIT2JLuwq5Xxn1QREd6s/S2nTr3jxamy4N7iJSwrMMuRDBPfHe\n"
	"mfOPR/taNCQsHHuevnfckSgqlTQqrpmHlQdJqkl1nyPTLqwBn1ANgge8GRcz4vqC\n"
	"xlQ5Xt2oTn7vV76j66lRmhGSnCjByQiO+20IqahpRJ+zAGbyn1z/wbBrD5Nb3T82\n"
	"ICCOWVy7443RwUQb855ya2d9ikjMXXgzx5bZCM4DsrnU8/YQhgzqwnNnoRScJSQs\n"
	"eDy1XKW4Y0hT7T+lwIrc8rQA9qEoItDLQog1xhLyiY8dSCJdZkuezZau8mKeSFwO\n"
	"oOEgN3kXdwYt3Nqmzk0qaBE2lkkUYLioA6PQwWqRT7cvKrzV8QpyauGwBONWm280\n"
	"Onf+AWImo2vLRgKZLdCduiS6AIo95ZwlnJd/1DNWUL80ZkZBc3SdwxSQIMRtByxt\n"
	"jPTv1O7iH788wWsigVOpzgOfBtM06mCeUwd05kiHCXnaVJGOen9WPIl4+mPdnXt5\n"
	"VuhVk+zapy6R0K2NQ8Fnz7JwhV4N/xoe27r125LScIgPfNdvu8612pxDi0dj9KY0\n"
	"RUrbABdmHR7ZNQzY9Pc6kJx79MF/67ZGH231u2/vlcjxBtjrxKVlROcVkQuwTsg8\n"
	"OB3AgRFeIg4x+ZMvpc0ECSZYSxVAF8eI/nl3kHhv/emeJDdGEGvRfyliHybQcBnI\n"
	"UYohT/x6Ac8QfoRUVCVvOYb+5s1vwkY3B+IBONuvoFYv9oX/iXGovX+A5D121m8r\n"
	"i3Kzl0hdxI3/8JET+uFQIKX6SDsO5d32H/GDVByeeQgbKZRvruU0VdnH9qWX0fTw\n"
	"CkH2V259zBoW9aFzfuwZZOdoukSfE02qU8Cv0b0EdkC1R7OsZLHv5hEkofrXF6+6\n"
	"iZN4xf5PUeU79hIqhfZHdCT0KVZDOtPvdwJiERqLlsMU70xfTSFFR9cEqXa7wYTM\n"
	"zPA3/WhJa5cxhBtbk0/5QByEGLzaKFHbODZL5bOXg0Javu+PA1dqPR7VQrALGTbK\n"
	"kbHt1f9RF72yS21mCv29rw2tbpo2iSJOAboEqrix+O9upnf64CI+DpCeeMsQaLN9\n"
	"Uaejj65+TLfLnJzcwiAu+vGjwiEenuJep/l5s8F3JigG4CERGnsIMFwgOg4VbbHK\n"
	"WPBPClp0wKYLauYma7A2/EpPWv0Rn+OKrCJXDzO6Fhw/QtMzkH46UOs4VUFb3NEX\n"
	"iVIpffT9xHtdo+UZLpZthOy64l5SdaxLjaOtCI5AfzzHjOstyrCRyEuXlIHDrLBL\n"
	"RECzMEjw6QfMWZsEivpDS+CZ/L66B3qyy/kRzwiZ+DVRB0FZyXOBamlvwkUFONjy\n"
	"R6q31uBV9l9X5w6O4xOo50c/967ifaH/p8QLB3iyTXZ/J6wqBVu0yQxc6RNQJ4Yi\n"
	"y2yu9FfsEC6lEhJduX6AAr8TDSQHhiKhcjnUU1U7t4iQSRkh1Yt+v0naJLGI646W\n"
	"CFhzi/4Ik4Vbr8MgGEr3oiHTKC17O24ngP4YFdfHuHiYfKB0CTrM9C1n6dvP2o86\n"
	"XStLcXpc6ZHsaBxdfpnF+mPgB93/tcVHcie2qUduo29KSRlwimKLCQIDAQABAoIE\n"
	"4itvYAoM+4xwWAS7aSZIIdGqQvElroIlfqQ96idEQ4JQrz6h60jiWQc+0DuPKyJN\n"
	"DpYrdvVGc5SMJJSNF5CFRgTYfO8w7Th2OOLq9jBE9S8uXNR2A7QQzCAHdLtz3Wqy\n"
	"KFiG71CcWVIcikifCyUwa8omKsyGdaMrtqqAOpMgtZWrR5DC7hcBk6KElRqR5rl0\n"
	"h+Jv78MkwDRmayTQ7zCr54hTtxBf90ONRGbps3LDXTE3Ouov1IVSwe5fZbevHu+w\n"
	"lH6d0GW1xmso8fqylHSyre2a0k6EaLK7lNUPRG4RNG2zG/ZEpKCLjrjBTJO+BxMa\n"
	"YTwz/aeHfT/R6WDcCnrPIJqjNgE64AFLjTd/HI4Zos9u1vHSbJtkKkWgdBG7B9H9\n"
	"6B+8jJ9kIscknxWXw9+QUMsXHAR3wpNkQRBQTXfxDZ2souZH5na4CPJk0ZtLiLJ5\n"
	"hBIf6fcDG/CrtoODVVo6c5aJ0eWYPHnr1yrQ+8Di3X08NlMNVTyBI8aTd2/MCSPY\n"
	"eocvlhUVHhPWv6xSjH8mClclIp/239N1Fyz4V1NZ7I5z8UbYd4r4DnedXWjbrB/i\n"
	"SphoNMygN9E6CSdgMSyclC53DYR8laW0fYqR2GNg6omow9SD81CSLnCOyVad17h1\n"
	"S7YpkqxErisIVnylvQzhuEJ3o4+WWHxTVv9HRxr1bI7u+93sify0cqPyBXTwTDmB\n"
	"u9XEjgHvHOJgbR7ONbtWoLpOQVA5xl1x0NpSKFq+JK0wjGdNguMCm3QAFpTo4DxE\n"
	"32voxO8KaTzjZMbfI7quGIu2WgkFw43D73XA7iiUDg/AYC03TjF2jM7KLCXdxROg\n"
	"35gRFl1AFRfTV39VwxN/pMGNx5mVgxsQDtwPmrbv+rMlTOgn9gBAXw+9P5ClV6bl\n"
	"I6BdmNVx2RLf1EnTBYeq8FqEcSX+AkG5+TdP5Oaq/pNdP5s0UzoxI2NyzqZF24kH\n"
	"F8ixnTQma8Q0s6TapR0OqLaNCj4EN/jnb4FbKS8h9oGmJTUy6J8lxraChQkUhA5t\n"
	"yBOM++NmiaUJQc88uZMAI7+6kBDEUPjZlhJTO3iaWJVZm7i0IErySHQ+Jj12sPuo\n"
	"nFtSh3GTjWDGZANufiTy0KJDopTYZp3m+iv3/5KhkbLT/gdM+SoP4mGRVC7ZYbqd\n"
	"ibszOv0lbN6zLcQjd7MEMMk4U5N3hDzo+Jfg8zbC/Q3A0GhgDDVhmywL7uyMCj+D\n"
	"+JW0T+bqsxbCUHJARSgZMR1tE61GJWJ8M8Nj+7WLeYAnzo8PrrDS1rHTsav6YBUh\n"
	"3sjg12UG5nAhMUC+jiL75OOTpzqkzSvcB7nGhLo+0DERtkKuNeUOnfKnEA4W/p5b\n"
	"QtEdTlTPMPiaFWLaQ6iw5i+rMJgNJp5oUxe5NILf4aMI3OgjX3yZwqo/vo66EqZG\n"
	"9qo6isHr4fj8jy9De5XnECeJyEQMl6Yv4KjuX8t2aGJnAWEUMCEtVJw3Zi+0O7wE\n"
	"OPoRBp8noSfPsNNww1nsK85IoaYdcS0fmisom36TOo3pKTZc6ZcpQ4sPUrMJ9aW1\n"
	"/UC7lptQcTKgH4FORICXNV/xojIPCFQD3GTZofCFlvebGanv7pzgGp1N6fzuO2eI\n"
	"b5bjvy4BNRiV106ltidEZXG2+o6zVNsdNI5zvNNDceFx8mf7EJaVaWOrpp9LEFLS\n"
	"ESUBAoICcgDrL2cZ1Om4iMgIAS00cYO9nchWx5s/MdDF7vZgBACjNmEBZoqMpNZb\n"
	"NYjbGcIfj1WnWrp7jMoyyWbqoAaQAMyUWTvnD4ftsOAASVbWUpv1FdiqTRlBZVva\n"
	"Gqy8rSyZa2H8Pq97mWA9w1zlZOrJMtybpk28iyjRy5TZSV58OM5qO6KlhCy+HHlP\n"
	"UCOQZ+AFLOB1BPI4D64uKp9kzadN1g4EQMvF8WnAupU0k20h8CDIUdctxnny62X0\n"
	"J5aPhsq04ci1TU+n6WAM/yStTcUAd+JZua4kXymlpDr2zSsqtgz0Axcbe0FVYJG3\n"
	"uvDco/fgyAEa9M4gQt3oatQ0LeqqzLM1761JbnGQikExQM8KoCrfGQ6MUzYyL7KU\n"
	"VXzuXNvvZHyT5NzKrxaGTcDlY0vvqrxei17kSjfBdss7eH+Tqytzg4SyQab0NvnN\n"
	"W5+Rw0opol4El+LRFARERXp+HerFaU3Er8pZqlpnDA/XSlEy5jXJcwCMWABTuuvw\n"
	"5nuTw9l1SEpnYm7x/x+P73gCUdOMeGX06w7k2Y3JnUvifJUrh9axMjCIXAMLJM7a\n"
	"1EF7reOoJtVN/7slxh1eTAx3xFAZ+iDte5yEqNK375SlVWMm2BnbvG3H50fCx9Lz\n"
	"KZ8cOKYKNZ5Q7iImNQ06jjoQzHAI4oJdvjutvm0TZSjDFUBHgcFTgVdZZIXweJSi\n"
	"63QRDQdjyoaB3jowDRwP/AWI2o2QzapmG8zEB7gDafbam5IROf0gcj+/rUo9Dlor\n"
	"QMI07d0qpHhL+VAcn3b8MI69rv4moB8Kf9RqdRyVJ3hua7pQ24B72KjC93noUrW0\n"
	"lILbi65C4AufAoICcgDXLSTE9lkyrSr1Lamb3ag0SWbernBtkkTJPktloD6drQg7\n"
	"lsXAFaV62SazBmg2ZtayB9D9HUU276F0sWQbxBD9hO/WGnVOMT7rgu5WMuUKid+H\n"
	"oWj5oT+KMPccoPjrsBZHlXvpgtb8M5dp+l1HyRR1YN4J6y6oEhRDoWAApDgA1B29\n"
	"nuICrMlMFE0TkNFz7YsiMMkDYAVGbjjPhCJu4eD698Ktopl1BUAKJwfI+6mxDDSu\n"
	"+F6z2/0alJYo5Qb6+YsUSOpjCyRwQbahO/3drb4Gv1B5DmiHDhSZ5UwzUQbHdBAE\n"
	"9PeColcWJtW5msRuxwZkbE4QGuWzQyBGgmy8bF0hpcaE0nbn0RQEqHHngcrTuu1l\n"
	"zte9k8z6BLwYnVFcJyfTjGWqEr0Z5M8gpVNY0OHxuqHTpXMwFigzwEqH5+EHtGGZ\n"
	"NN/daeUTyJgU+OFnEtoHfDCRoGrNbW2LgifJeOxvGvczVcF111jfuSehoVvJG1kl\n"
	"1iQXwj22HHaDvJFQRDgEMRXnz98UikQwLolfSJF4qKENPdhWq3jmVCjdFLPuvxq4\n"
	"q0fGLa19XWPfLZ/Fw0Oyy54Fq8Lm67EkeLouAB3RbSg9fwBNJw0p5XTiHykR5pBa\n"
	"b7mkch/+GPrhuA/tsO1U1bFn1ykGswSTiUzdtBbYRXuczX6SoIuJgCqwI2RIZ9cS\n"
	"k4bwnAHEcLHlZ2pzaGNRfEjKUnNgXsUo6txi57UXwaugvQ8eQiDQgYXKlj6jNden\n"
	"2RwXhBHPFF+FRh0PGcGKOpqjptb3r/EUl2C7RDsXLClhJUpDDWb/0nnn175ODSeM\n"
	"DKcHf6d+CBh28n1mumhXAoICcTAiOoKx7cfDztS8kOjr1p+nPEpufdqYMndgKfKK\n"
	"vyqoRYBI4VBZqDlwonrdMbrN1iTzT7lbnkJ4r+STLeSpFTXDcZwftJ00FxRX7jrd\n"
	"G2g0uWxZbTLSMNNZpELVWoxnyt0aY0XzpRve8RNN7TOSgk4k4kIVZRxTAzrZZkoc\n"
	"QjrBy87+Vz3ti/Jsn2q9p77HaYTppz1MEEUImijCYlxu092Q+WOgvhkg1sq05aAN\n"
	"ilgVT+nhdjH+dZZbx9fGKZSNpUtd8FCYVf0y9um1Qf2Pi7b7ZqWxCFALZbn/Ubdj\n"
	"HRGP1FnehweXRRuKWiN+N4w8wuUmd01pAgvAWX/4ac/dJ0yBqkCeJwYDFcaj0fwF\n"
	"veB9O1oC6dOpqW3sdS4/uQ+szEZkj7+3x+9i2HjaMr9xfS4Ibjpg6jphOsUIK2wo\n"
	"mzMAFtd40lenLMcX2ne1tWcCASYFg/lwlFL4uVI4g0U2ASGhLNPfJrNyZ4eTgTze\n"
	"muGI9PLETATW+9UJBv++FLKJQhkYr0Y+BdKqmzA2WQql1ZAjz5+M2xUJaW+IOet3\n"
	"2LvZXs95rXHJbcChsmlCtJZEpGFbVo0rl/UlsWONvSsj4ztXkjggaUgV86FG8Y0Q\n"
	"q3IqhXllX22BAi6cNSFMgscSJD3CDyEsuHFkjIPFo6Rd33qaJZKwp5hRmt8aaVZ5\n"
	"Ov0BOsRj63nE4/7YG6Alv35wA8lulxAgjr7CwMs6l8CsJxTQ2b7BKashM9GYB3QZ\n"
	"HzJVz7BGIiyO1GuHzHeSuzIwCSLbesbw6CRDN+OgfgmfudqnQO0s3NW2B1LqH27P\n"
	"DePK+vc0OTIQQ3oa7xFJ7DdprVcCggJyAM8itfKk8tjFukSq4Esa5YDv6AcVBUV1\n"
	"OKJBRXNe/ufqWbKDQXnXXKUVxRsxX8B+3s4imBwQwUBRDau32Baid3iVMAt7DNFo\n"
	"tpkgQS7Zb4LlljiKOPOVNgVhfYAhtX2s1MW0MMRpH2tIfsmWKZWhDACybww9SXyh\n"
	"asBv6Gq1qvOhPb/74rWQf3atVEUxc2+VjAotzFNja7CRCj85g6wZ5Omy98UOcYsk\n"
	"srETQXtIR+IXTd/hV8jsTIn531MepcmTzz6HspoFb95gY95yUb/EMNlt8ZmXNShN\n"
	"dadwBBqiNVRrdcBP0LQAcrTwTW2OfunkzVJ+r+bw/Y3DYJ5/jw0Tg9OQMbpKoAwo\n"
	"SIzzWjLxzr5jg4QtyaDFVtyXEjrftiJvzvbmgDdoMoFqsblLbSBidB6u+nkzG99+\n"
	"dNTcluKdZRJ1oj5Jl/ccqViSEVSfANyoWRo7gsWtFyMJ5BoYARUBQxjxbGYOd11p\n"
	"IDS9mFkPa7v8h6TUr4nvglh8rdnC/F+4S/Q9DElK4gRz1ZBMPBFtWhw8uEx27HsC\n"
	"NjADdBLeixeY/7AlscIk1o2ICUweL1/AyLqlKEltPwHsgWoKja8ajZm86q/IQhID\n"
	"NbjPGeVS+cYxnWRxiNO0yPdiNKB0/2BgoRa5Xz4G8YdxbUZZNZV2d0daG9SmPOIJ\n"
	"ikmjB3TnnPHWhENtoMieZVUk5xteoirWokUezzN0i3yJvmHVNLJBOyLTXNQvKw6F\n"
	"ufD9vj12xHV4r1D0vwYkLMCbbBhvlimjMZxPLe27/dQRmpGn54Zd+EQmTu8lZoeF\n"
	"r1E03AVCuf+IyjkXNPMS/7ljManPZMgvSaECggJxdDsg+VIkO4id44ATLjZ006oB\n"
	"C2S+xktCmj1/GUXLwn4XkaWJU6C10rADD139hGyoBdWFZeHq2MCNJ2agKYqrPa6O\n"
	"qt+GkIDbbQ1AtUqW4xEL3koMhe7g4CpqI0n07orAoqQQGvmrTqhNCOz3ftMQKtkM\n"
	"qoiLwbdEU0X0s41vkCDxF52448ZMYQ5327kAa5mMG1lYrS7kQ9tLJ45z7RSw7Pan\n"
	"tTi18cLE42kOe/wdaK/nakjNoIUcJC8VqYJ75IOnkxmMrP7wWpigHojLjjG2rCiU\n"
	"qYwS+E5f+3WhESvu72DXjCClI/QQ5iQ9+BDtXzfzxVxpNicaAZtAVns/JPMzkVEH\n"
	"A4efNXo8CwOMCyqhnKxKuprPAekDwjYyr6fI2iqcfb0TpnuAp9fOkjgkVZIuLAs7\n"
	"gsyms9eniaFCGNLAwTkfEjxBVGP/5kSaka9w0Vj6g+mfeqEw2frD1LfEU5l2/F0t\n"
	"iFYmtmgxpAnlWOF+Y6dlKqFwZbFiqzSZNMwzn29Lhx7hONJqzMzGhjk7heYwB7A8\n"
	"8bloepcbvWcZJ/2dhmfsgk8CXVW22C0jB/nU2NpAcTki3TVAZ40cbt1fTdgS4tRJ\n"
	"zR9OgLsjfuTo0LbEPbPDldytP1Xcdw+0hdxdYUv+G2UsdNKAcx+c+9VisogwQ5Ms\n"
	"dUuE9B5EJO5cd8hz2w6SJ7Fe0uQHnXM0I+EtycCLcTjyO/ZMkQMZh7Yj37oOB+tJ\n"
	"D2uAHdq0IHmBrEQWHOBuhwNNLtu90yfzT8hIPPmoY7ho+qIu+QhD65FLVIu1bU+3\n"
	"nfEvcF4wdqMneAh+KlLyZbGSZdhZpD1YjP8cNvcO6w==\n"
	"-----END PRIVATE KEY-----\n";

static char server_key_repro_pem[] =
	"-----BEGIN PRIVATE KEY-----\n"
	"MIIWMgIBADANBgkqhkiG9w0BAQEFAASCFhwwghYYAgEAAoIE4QDlLopBshMEROYt\n"
	"nS3ZM02uRH0dFMreyhCNuoX5EPOsZRgTbGXM3myDqCWuIiFRf10OoSH8yzaT4nYS\n"
	"tvz91Do3JM/qHsNXyQP5Ql4NQkfp9sl8gutog1Y3svWM6fpl/mZTPTLAJcW+HPi3\n"
	"5GStCgnlXi6U8JLk4mmjuIt0m/O95x0EZ0qmC8Rn7Ijk8VHH24fMX3cWu+LSTQzr\n"
	"WAGoBZWcl54EBm03GiUf92MW5CP3JpoTq/cwJ65b103GGC5CEhlFWaKTKQJ8EScu\n"
	"ood3AUy7JvN13KIk+lw9cJ7Htw7GPe8ixzrsNaBIyJIiAFkS8iWYjfUGJkifM5XH\n"
	"enMAx5UG6hdHWvbkrLL50Dpy46sPJvzNfMiY9ukVOaEMVSlXwHkuwMU/ZxyJL6w/\n"
	"r3xS+xHdWQhDBgLFH4zIfUn36eEtDkGQ79B/wvx64M27mm+VLFWaS96lwfpmkmdV\n"
	"940V0oTRVMYqIYfAfFX6Sr+U6GYF7Y6Te0vMLNQjHweCR33+1iUO4U21QYNA6ea8\n"
	"Fs7wu60J9i+61gYJo+TN3hQPgBS+6R8ZIN7DNA6LRVB0dQtLIYhS7tPXm3sdOfP2\n"
	"L72KftzmLYeYm9tDSx8BV9EN6wY3GfP8YJ7RQAwSWowEQLfleMUbI/ZAeIsJAqvo\n"
	"dTQtUTDmzXWkk132HDe7bit+IIYSoUl70fOr4sJaF+cjPdWM6WjDUp7uSy//P3ZZ\n"
	"gfhI14TWXIEh/0eNvHP5toWctRKXb0D79D5A4fNz79h802fxWDfUg4Ol+qoL8Ms6\n"
	"NI3s1LTDDqJITwMQLFFuuUGvUD0x9WP0XHl7m2YcdQg1U1JP7vmMXsoa/zVcgovw\n"
	"IFhiA69Umlu8BipEn9xeQjYdyBMBMRMasUjXgQt9OoLv43UqLVzjd1AtRURYZREO\n"
	"T86gYU53SHHPvOyTA2U4ZyON0WVzPRLpHrg+9YhaL9bzXgcqtK13Zdj56B3jHgnz\n"
	"ge3MmjYvJntGtCGl2D310FaG7GWg775Evh2I4np5nXsA9dnSqySFzAP3rJ/L5pUi\n"
	"bQ+QDuYnNwATvRu57Gx3kgmMrMvKooudcpYlrekJUzjS6PfmsHPCYx97rqmeCvGZ\n"
	"m8O4PmxC0NDr1MnTuBGjX1IOTuICrzHfoDPa07hxhOwQ35wa1a+aXgQGP3bqTISq\n"
	"t9VV6/DWZ1NNsujAbbd+2oSYYhE9e4QZCCnpWQw1cmnwyVhvAVsTzkfDxwDDYBNj\n"
	"+L/uG8BaoCuAtA1exDCXiLBwuS9fkwuO26NJoCx/hVih6sIqe7YS2qcubJiByMeU\n"
	"YqPO/N7MrJK/psm7WG9Jby62xEYulfU28dYOFdjtFLaUY472Mo6Rxth6R9H/95tc\n"
	"DX7ndmPMtYkBUJ91QyGwXLj/QozlH7woVzm7kdZmO5sCu4aezXylPnK7cTVwzTsk\n"
	"3moucKsMshh9Sd+baxyVFrXlvntOGkrU0FdHh2aF47eCb5+agu3Aw6PHK+v9XsUR\n"
	"FEw6xqqIp9aJsY6VkjM4zcglrrDJbAbujozRAZp7D5XPtSDfBAG7bdeZOCA4DZUE\n"
	"QxY2HRJw6OeKLOclaEeCxW1LKBWW/oYbyo/0tK9ND+mk/WUOKXeBA47F+OGZLP2S\n"
	"JzMWxJLuvL1XbMzHk/nrtN+mzgg1zbLdwuX9XUGcXQCDL2w3SCECAwEAAQKCBOAZ\n"
	"dUIGajGSl9S53GvrZLeMVC9Ru62NcgTEuaOIN0naLKCwB6qHR23mchc9cK0i0HMV\n"
	"3PBZlHlLlCxph8oyqBCPb5do+mHYrouydJzd/C7g3nkjS6e6xFwfc9GzBYq7KbdU\n"
	"J8grcAa3R6CZTNWiIytWP1ANW2v14PC7LxTOr0Q0JCglBRRVvZjjsnLCe8wJ12kO\n"
	"Wsxvyg84LTbyLaSBdZ1Y976l09Dt/gmBs4leUZltKuySoteikcXcjd4l0ynQTRJh\n"
	"kcNtdXDBN2aS15sUrSBI6drBjPC2CtmUOZ5psPwDKX4W7uqssohLjXwuKru6Twu+\n"
	"FobRWA9ZH/HTZta/j2wOiJJtar1iSYzYEzlq6b9mv331lZby5vqdUPmC1TLyfH75\n"
	"opBGqr2Qv6ryqBu3XAxv+iPgzhogq5CH9OLylxhcWOkPoJQYnSBOxgoUfONIPtSD\n"
	"f0oMP7ABFOJFumoBspDub+xTYcYiq60hUIxXjjlHD0x3NYsF8zTdceTzo91rIX6c\n"
	"WIq5R728yD7JRf9W3oIqSR6kMoIZMAuKktDHqAKl8l9x+yTDqlSzQ8/cH+RRRDhQ\n"
	"fhcqLCtQ488l2cfESrNfHk+htC53GzEmhQrD8QePt2JS9qittd+hak2Da20CIJhE\n"
	"m4oPP1Sye4l9GQfiwNId0VTwIy6c2CWYvHQ4XoSGLURsbLYUsevE9kLGt2exb3wj\n"
	"tlnRPqjmQbZz2uwpq0cmSMBPdnwMUpLPemb9MWAPUlx1oHwJ2Q+iIVJ7C0DQnmwV\n"
	"P0aweVfKW8U3gf8B/97UjBuazKwab9Hb6thRESi7E/c2fc9A29JL9vQieE78ch8w\n"
	"mEIp8SaT/l09gq6mTSUhYl6k5Z1iNHtrqgRr9uyfB5+fm4P3Hc5GzwCC38sU7rL3\n"
	"zO6Dk5z+3VD2T9L+X9vZ6Z9mjvzKylQpZta8d5EAWkUiPaVY8xYcbtNKRahK5zFB\n"
	"wgzTya1uFi9C0TBG07OONuT15bagbqjqsrZ6daLxqtiX6CUtNEAp8UWLlR3jW2/r\n"
	"p1iE3AeW61MfKCmvsl+J9vZ8Vy+iisFaUVJWfhGFpH5WCO4idQiXZyjfsTAQhPV3\n"
	"yBB65LVsXCZWXOiiwmmH3GIvY7fvVTQbM8Rz6FlLr8y8VPACsLJE2OnfRlwZvKaC\n"
	"+Iwl1fKq+W457VdtkVMOzwAjWbcUpwuOzoUnuRoWj7hH+CuNwSeWAYWfPB+obhBN\n"
	"g01jfzY/GKBoYmu5+5nudwhbKTzt1zJ7aBoq0iJ0yWD12DtQImWiWU7ax2wf9pfe\n"
	"lIUL/aUJ2TxZbEYTOl+xeogQkikuSBlNYtM1coOjsXSRCjULW2f9GAl+VT/BA5ld\n"
	"SwvRAgBYoC+X3r4IfBha5nrZStllAwMjgtM8VW2ZgMe7he7csY0WbeNNyH856Pe2\n"
	"2lT49CjudbBytuPbRJXnuiiCVJnB3Qc8ntTthPIFHVLZRrNex6SGG22ANC27jKz7\n"
	"s4Y+JJiAjZMfe2+Nvne3Vd9febCokhzH1HNHOjCx4U4sv2rmmCwGpw1NwRxX7hau\n"
	"4cKPXkhH4iCurpG3ZbooN3DRRfNRdXT/G9Klt2HlI8kvdD2PCNtAGOQOHmHzZdKL\n"
	"V/HvPkqTCdi+OuSPS9YHeHFZZUpqUZ+7eiyjQ86KzgmNi/TQWR/6IEIYe+k4QMEC\n"
	"ggJxAPL6qmGPkdU4spW/FM4NmFG+ApqfisFH1hU/BzGqnL6p7DdfqzcgydyyVC/3\n"
	"/j1QsV/2mh81a/Kho1AawHghjxz2k8ekARGic62tAf7pqoZFYtdGXa9hhned+9Ic\n"
	"3esSItAUKlhX+XlQ6mZ7XUEbt4+6AhkZtiBgIHAUpoa90M0ru/zUoudUKatTfcAa\n"
	"x9C6Uc6kBSIx7L4anGanDHuyivf3tl23UiRH06PHvb/XFCifAb9uXjfZ4+FiZdvR\n"
	"7SM5EROtqJSXaMu3E/ZbK3qZSA4MK53Wr7lfKsyfvoDSxbauUPkUr8qsdIoLmIn4\n"
	"gSjlFoH7ZFZVGgTB3ZW3DdOEm+7hGVwIHRR+KyM/oQevDspHeQbxWA2gx6MUavPG\n"
	"KQVe8dAUVvhP0jktgwCfN/A6S/1yTXYxkmDmjlHUbchyD4hv+/3Z/+5ChAtCjVX2\n"
	"+ybqRFAkJbqGeHUonWK1w+qzordT/9i/4Qg46qjVZvfvsEyyABMCptFaV4sPMJbY\n"
	"CUFpCLEsQ5eHa+GgTp9V0rXoITsemJjXTAUxnEUjZ6MqfQkFs/CsLAoOaD5YjGdQ\n"
	"HmyUEw2sRn4q+iFUlB3rq7BBqVyUrPzI9FajWlKL/Tr472a35uTKEd7Rvm/unY9Y\n"
	"P5HM5o9v2hY3jF2qgK6/ksYkrdEVL95BRIXbJ8bk44bwja4eEfAESI7Rpc31bXd+\n"
	"iNKnmMaB2A9iyzhZgZd5cTIpLM7rUwO7+IH8sd4gIKHVYUpy/KHJQ9wPy6pwc69R\n"
	"MJ6HljhaRtaethkwr4Ehon3fvuQcll0rXfhbh9kN+UfE+77psBPyrLtNTTke6Ucc\n"
	"4UkXGwKCAnEA8XaYDScKT2ngP/BPE9Pt/YiDoqhfGPCVMKC3/tiErdeoCk/NW6wF\n"
	"00PYmaZVADXZ++kjwFfXv2w52k+8E1TEorUgap2VpAMFGmAasLkey/AuOSHK2zzU\n"
	"5BWF2gwu2vDiHDs59brcH2fxGRtF/rHkZIq+fs9uHlIXARq7Wlcuu6ZkFT+qRGOl\n"
	"091rFAhPmYZekBQoCjUOqPtxVPoGvdpp8SDjwet8KUBPgY0WEyZ0jGwMl25pCmlL\n"
	"DGFXgbUm1dtTCxFyTC7fcp+6GmrT5FwhCBygY7pT8oAqV1C/uyvAcfFkIZAlRZQ+\n"
	"FTeK8Kug2XBO1ycD5LrNZEWv91bQsMt1iF3A5PFSMwjcC+s07ZiAfhx0A3HX1sWV\n"
	"VvhP+0NdY4aI7YQbUO4eSGiYOr2JPlOIQ9ObApOjQKysTuWTkwcUWCCbsMDk5CrR\n"
	"XBrN91X/BJkLvcax0lPNpAko+avEVwxd/MsEKg8Tcc/rZajzVxqYei+fiCB7j2ye\n"
	"V1SfpdFbScSoKreEtUEx+3BUVLAmmCmEtsO/d3b7G8yXwakLn05J2Vhw/3yNUdm7\n"
	"hOYXMuqrEL2TO8oFTUUKRNRml0m4ymfKrdy1VLgx7wVUNNM/RAZEGFtb1B6VHF3E\n"
	"3AHqR22H/aepgBQkN5s+P0eMgVOiEI2KTDGkOye0UgI/+7ZtfjLjGqvqX2X9J6Kk\n"
	"QqfNl0jOTmKl0/3zrvAR1AOrTv6EvDxsLOfh3Nlr2I/t0RCzkeb5ECSiHmK9EjrA\n"
	"b9cED3fgil2XiY7uyRW+3TpX6PJWSYxOlIaF/6YCy/vj09nQhLdnGQzuIEQLQHJn\n"
	"nS+YVXYR0SVzAoICcHnxma8K+dqz8NS8qHldU1O6892cMmwcXHIfRsIDaVU7PITx\n"
	"66DoQMcVbLECWkN1iv+paOI+0mVb//WE55Gi7gtQKQyp36t1B29jg7vmk6F9k0SN\n"
	"WRla7bx8ulRSDoIagQRDCpl51YewN2OliEDT40Uryj/EqqYG+GCnzIeVHgTKbTdP\n"
	"lE5a6+rDJTpTdnLn/4Sgxr7JpZInEtVmAxrVmW8nkAvqpDv3HF13MmDkVYapfpwP\n"
	"jROks/x6gLpY2hWyX0KsBg5FCuAqisc6LFEEOqhqLT2y8FAtVfKKPXaz0WyEgbjw\n"
	"S+WAtaBOf4jHAjN+/dPQUiQN49f9X/LygurkA8pYiHyqycVuKMIw/eU4U0jro+77\n"
	"EwEL7wWGisK7cfzzEJMokhlfHhd6IuQeBFn5OAgD5KJr8JXXQBgLb+mIbQlBgot9\n"
	"bDeshE6OYRaCtLtsGUrLSXAaarwJ3SscJC5XZ1NwwdeLPSn+Pq7rIxlN3wIu12Cz\n"
	"FPu+xm7Q+cbKt6JvT2Bz4Zxb56W96ZeH4A9RZ9Qe3+DdNJbqtg3w3eOCwGvVw+AG\n"
	"2LdXUbPwhs6W5B4EFqfnDR3m/c/afdeiXnFAEvqW11aqmA4fP4ZsIXQGWUgJBcVP\n"
	"MLbONzA/5i150bWfyxqzvRUnXbfoiVqqZMQyxlVHt9VoljZDrevhFdu0QLbg+oml\n"
	"7LBYwUjjYsP06kAmwsLliYT3RRyLt0FJPqk5Bvb2HZyjKu453x6mqxntWD2gBfBA\n"
	"bWE1QDbS5wxWx/rX+2lezWyLDMMJrxs0wTNBJrGfM0uhJzEs5rnljHUbhGjlKWxp\n"
	"f40lF5uSSutYsCwZfwKCAnAiRppo64zMHxRlHyCqiN/0qGc/NLVjHeufnoDf3S5g\n"
	"WweQhyl4hN/C0JOzo+fXAs3xs3OOvylyE9PWiJEDEXpkOl/iooH2aTNVPiUrxut3\n"
	"OZ3mIETigC0cP23juO0ByUXfigy9NAxBLQkNblCuSeRI3WUTLTDNfwui7X+A4HVS\n"
	"z9jPJ11tHdQRUhH8Iv3hpjBQNXxFjqiJFkBNNry0QIffYbLS+TGDzYw7sKJcj43l\n"
	"zQSwjky83Jt5o2u/js53dw2/uXdHFzRC2ieZzmZLuUQ7GY0u+ukluEnKYT0GPbyw\n"
	"r/ptxT91NAjoDB1d8o7/rrCSXAhydI3pWPcUni87mXYSqHRUS2lGs1BBJN87hvVe\n"
	"cX2Ka6Oe6ic71D3ORg7ArP1M8f7KqzKDRs2tMPCFd2gVcLlFUV3QNXK0NGSRb2TU\n"
	"6bQQECGtveJAN9Ha9UshBPSkuMrPN3Quf9pgLqDNVoUU+GCb883nzwL0SFpal/zj\n"
	"A1WbBjlj76A+d1W+PQy/WPoiLjDZZerJbXWbG/IukV40b28Db1FP7efw5qUutPdI\n"
	"sgRAUBbjcovq3pqWcLddxftbdl7wTAecI6Z4fU+M89TSf00CPK9h5ZjBcuc9KcKK\n"
	"zpUndDvobese6+qsvwCZ4i3ub22AsznP08E/LncH8H+cN0O/3e/74DPi8E90pZaV\n"
	"V6gKaLjZ4n18tMM7YWtftyMhB6CKyatONEMiEIEZE16rtTLbncVwVWYF0mAbKvVZ\n"
	"9ElLFOsP5mUgux3pcDPgkE6NiUueIccZMkn+WEAlapRRAxOMaa1l9Viu3vF5lWs+\n"
	"JBa9X8tVF6hbqMDwCLWYwb8CggJxAMwL6SAeYP9kjq7tkk+TmZVTHDlV4Yw9kWAY\n"
	"a9etQ4vJibIkyzrfJXIVmsY+df7m3uaNWnmNe3VuZxLv04sPyL8OMu+PIUct3174\n"
	"sNYN5AjmjmuBLvs1vBF8VvQ8+TsH5HjzXYcSQM3OJ1G/GPjsptqHj/w3kLmHsQgW\n"
	"Fps5OXWgjQEsVnrRL/Z5D6s4z8OPMRN3KAqb1k4Cp5m32f9bzBIHEPdHc1JLFx0X\n"
	"4xFQ4m1Dfbab8/VGnm9mS67zDtJWjxUSeTlR84hONXqzPke5h/W4QGrUgHutm0zb\n"
	"ch/CufhsxF6RjiK7EuKqZWZDDj0uxqOlI6X/Exf53KZRLwJlmhdaED5LP8BA2IHt\n"
	"nRL7F0uGfaLMP5CCDyN36GjmrlCEilwQQSpJF6QnYEEkLaxjksqTzQ54ZtboLf7O\n"
	"HY0iYN1fmuWpf41ljljHe5H58vKDr/oQkANfz6I2lBCdmz7GkmBPmed8XHJSWqs8\n"
	"41tyHXPBAQj+1MQtsW0xjl2ajoF7mwrRVHQL0xLVQcwmXqNQyMJ905WRMBhLShRR\n"
	"hXipo7nDHDE8jiRyTZGNIg12D6tDLD5tmPXK5Hmzn4pLPWcN6Q9UvWn0PWql31sx\n"
	"3dNqZ6PlYyh0b92+pymfDF3TBvZI2PeOICQsiFnqwhMyrV0Ojwt/QxIFudJJf2u4\n"
	"7EA14n87SVjMhF1l6BoP4wdqt21uU0UhpyFACCoH2arFFulGJjC2/d5drNq7hSef\n"
	"LNMz9MPPkamMWQ6i7vlTlUjAOtIfukre/fG4qyVclTaAiKx6EXt98DSBjPLoMJO7\n"
	"3sczn4+LAjtXDT3RX0aUWr+JQABd+g==\n"
	"-----END PRIVATE KEY-----\n";

static char server_cert_repro_pem[] =
	"-----BEGIN CERTIFICATE-----\n"
	"MIILHTCCBiWgAwIBAgIJAKyNy9vjy7TCMA0GCSqGSIb3DQEBCwUAMEUxCzAJBgNV\n"
	"BAYTAkFVMRMwEQYDVQQIDApTb21lLVN0YXRlMSEwHwYDVQQKDBhJbnRlcm5ldCBX\n"
	"aWRnaXRzIFB0eSBMdGQwHhcNMTcwOTEzMTAzNzU0WhcNMTcwOTE0MTAzNzU0WjBF\n"
	"MQswCQYDVQQGEwJBVTETMBEGA1UECAwKU29tZS1TdGF0ZTEhMB8GA1UECgwYSW50\n"
	"ZXJuZXQgV2lkZ2l0cyBQdHkgTHRkMIIFAjANBgkqhkiG9w0BAQEFAAOCBO8AMIIE\n"
	"6gKCBOEA5S6KQbITBETmLZ0t2TNNrkR9HRTK3soQjbqF+RDzrGUYE2xlzN5sg6gl\n"
	"riIhUX9dDqEh/Ms2k+J2Erb8/dQ6NyTP6h7DV8kD+UJeDUJH6fbJfILraINWN7L1\n"
	"jOn6Zf5mUz0ywCXFvhz4t+RkrQoJ5V4ulPCS5OJpo7iLdJvzvecdBGdKpgvEZ+yI\n"
	"5PFRx9uHzF93Frvi0k0M61gBqAWVnJeeBAZtNxolH/djFuQj9yaaE6v3MCeuW9dN\n"
	"xhguQhIZRVmikykCfBEnLqKHdwFMuybzddyiJPpcPXCex7cOxj3vIsc67DWgSMiS\n"
	"IgBZEvIlmI31BiZInzOVx3pzAMeVBuoXR1r25Kyy+dA6cuOrDyb8zXzImPbpFTmh\n"
	"DFUpV8B5LsDFP2cciS+sP698UvsR3VkIQwYCxR+MyH1J9+nhLQ5BkO/Qf8L8euDN\n"
	"u5pvlSxVmkvepcH6ZpJnVfeNFdKE0VTGKiGHwHxV+kq/lOhmBe2Ok3tLzCzUIx8H\n"
	"gkd9/tYlDuFNtUGDQOnmvBbO8LutCfYvutYGCaPkzd4UD4AUvukfGSDewzQOi0VQ\n"
	"dHULSyGIUu7T15t7HTnz9i+9in7c5i2HmJvbQ0sfAVfRDesGNxnz/GCe0UAMElqM\n"
	"BEC35XjFGyP2QHiLCQKr6HU0LVEw5s11pJNd9hw3u24rfiCGEqFJe9Hzq+LCWhfn\n"
	"Iz3VjOlow1Ke7ksv/z92WYH4SNeE1lyBIf9Hjbxz+baFnLUSl29A+/Q+QOHzc+/Y\n"
	"fNNn8Vg31IODpfqqC/DLOjSN7NS0ww6iSE8DECxRbrlBr1A9MfVj9Fx5e5tmHHUI\n"
	"NVNST+75jF7KGv81XIKL8CBYYgOvVJpbvAYqRJ/cXkI2HcgTATETGrFI14ELfTqC\n"
	"7+N1Ki1c43dQLUVEWGURDk/OoGFOd0hxz7zskwNlOGcjjdFlcz0S6R64PvWIWi/W\n"
	"814HKrStd2XY+egd4x4J84HtzJo2LyZ7RrQhpdg99dBWhuxloO++RL4diOJ6eZ17\n"
	"APXZ0qskhcwD96yfy+aVIm0PkA7mJzcAE70buexsd5IJjKzLyqKLnXKWJa3pCVM4\n"
	"0uj35rBzwmMfe66pngrxmZvDuD5sQtDQ69TJ07gRo19SDk7iAq8x36Az2tO4cYTs\n"
	"EN+cGtWvml4EBj926kyEqrfVVevw1mdTTbLowG23ftqEmGIRPXuEGQgp6VkMNXJp\n"
	"8MlYbwFbE85Hw8cAw2ATY/i/7hvAWqArgLQNXsQwl4iwcLkvX5MLjtujSaAsf4VY\n"
	"oerCKnu2EtqnLmyYgcjHlGKjzvzezKySv6bJu1hvSW8utsRGLpX1NvHWDhXY7RS2\n"
	"lGOO9jKOkcbYekfR//ebXA1+53ZjzLWJAVCfdUMhsFy4/0KM5R+8KFc5u5HWZjub\n"
	"AruGns18pT5yu3E1cM07JN5qLnCrDLIYfUnfm2sclRa15b57ThpK1NBXR4dmheO3\n"
	"gm+fmoLtwMOjxyvr/V7FERRMOsaqiKfWibGOlZIzOM3IJa6wyWwG7o6M0QGaew+V\n"
	"z7Ug3wQBu23XmTggOA2VBEMWNh0ScOjniiznJWhHgsVtSygVlv6GG8qP9LSvTQ/p\n"
	"pP1lDil3gQOOxfjhmSz9kiczFsSS7ry9V2zMx5P567Tfps4INc2y3cLl/V1BnF0A\n"
	"gy9sN0ghAgMBAAGjUDBOMB0GA1UdDgQWBBT27j2hLGIaF0HRrGTPPxyYPcZiVDAf\n"
	"BgNVHSMEGDAWgBT27j2hLGIaF0HRrGTPPxyYPcZiVDAMBgNVHRMEBTADAQH/MA0G\n"
	"CSqGSIb3DQEBCwUAA4IE4QABjOzAO+aLbSvGPc5J0dFJV2upqv/lIQuwYkYwiDYn\n"
	"jYiKvdldmx9DA4e6l+yE/7yAphz1qviySPzIDl3zsBxoTlUd1ghsm4R7euC827e8\n"
	"MsJDMK8CfsXepqcvca2nrNpakDZ+z+e/y+UoAFiDMZhLX8N0a1+5+cQrONMMqEWa\n"
	"GRV+SlH2dJHfi1aG981Br5pfoJmQbWRjj8sLM1e2EIe3NovcVDnS//7T3PcDINRM\n"
	"M341onBL93/yv/iBevekTkx3FnjLF7qJRRqKX5bc0+H5Fe0sV7ObIEAAFyrRMp/l\n"
	"A3AYCZ5vu9ueWdmmyuBZTro6eWyQN4G1WkYVYQMpa8JwOrclpSaa/d5f16u4wRLe\n"
	"JguamO/qMbxpaVJPSXXiX+dwyaVow6l7s9O1+jrYDVhJACVP0OIfLtPeBZlbo4T9\n"
	"B2XeFbgOZXT9gfz/vsq+pH9rBKrtvXzYAWEThlqjh1qNKfmG3bYwSJhsL5NnVOae\n"
	"xZ8VveeDV05VfIQX3NpqK9gxoVMlbMX+zEdRpBak8d4P+wKMrLm2Vg+1MtfMsDes\n"
	"bi0i2oHH2ESvY7elv1YTgORXjz6HmzA3L7oaISNgIoxbzVVu1hhBTD4MZXaFHGbW\n"
	"E9IpEhHPNK6UHetbxJwN2X2lONEOwoDDzXerrmIjn6yHJetLOBTb0IAdaOvzEmyP\n"
	"k4lhXJ9uOd0hdSqAIgKiFrrYNnXvYGMwItQPyI0KXN2e4B/kgZX9L/4SQwIpJuHy\n"
	"Voit0WZVCAhIxA4SkYi7X/5qW2t/Kg4kfUxWO6itq8QChikSatkyLVtv9SOksQnm\n"
	"2+alnBWhEziN7T4teM1qvj+Deiv3EYPaLBw68jJgKJ55lTt8vbHDWw07WUX7xP6C\n"
	"BVKPh8fDH/j95Uyfsv5WxKBfjUFYD/c2R33AClST9iWCmZn2LJm66rzOx/dZ19eH\n"
	"BJHeooCCzmk9BMrSLqcuzBaUsKjiKrlYeHa+klqgYhhDQxdxJ1GRUZbEywVc1+FL\n"
	"fnDK2edISlUDZ2FsOK+X+bf4g5UhQzhnJZwTZhH3m35tM7AvX3ZpRmSoApbAEbqM\n"
	"ndj3v4z7l/VYve/waZjVwLL+lzKTgOKh91RxzJcs34j/pvi9Srf7nif6O9Kf+F7z\n"
	"bKKdN4RAypUxv9v0EjSolQ0lpUNQBJNJeepgqLzVNdDaEOAP0g/5LsFscpfawo80\n"
	"KRCIJH1+C0OqZpHcu9w99l0/NsVOb50+IUhe1gA+wZDC8puODmacWNCctXG9cojZ\n"
	"lcagSLUvh1jt/t6fsl2ObyL64+1RPrvi1A11mtqbUxS4iTa6l45yth+IjbpexVwh\n"
	"YJUKTfBnWzS1RNBPJwsn6wRuvIWZT/VdQ5q/lTCWvovKPKg/gnwrlqqErVXgdgyG\n"
	"YGdChbh3R4jYgHlUASa/xo5Nes+X2DRy+2OzaHrDKdo2pxwqMtzQjogPVTBOG0r1\n"
	"iCNaCF9hLjJakrxsaoLBlb90bJ1ZrlYtqNXwKZphbLvgVELsPCghrwhbV9wdP6Le\n"
	"zMnPLeicTSDPiq2nkDUWlbDd5oOhrTORf8gWRuPJVJ+noEkAkQEZkGHRnt3ouio6\n"
	"P0BTNfA6e2quOiZ+8YSvWwOlwO2I0z8vy1IPQYIApX3S0UCPSep33u3KdL28O68z\n"
	"pNVz4Hd2IpWckRR5ahdK00I=\n"
	"-----END CERTIFICATE-----\n";

static gnutls_datum_t server_repro_key = { (void*)server_key_repro_pem, sizeof(server_key_repro_pem)-1 };
static gnutls_datum_t server_repro_cert = { (void*)server_cert_repro_pem, sizeof(server_cert_repro_pem)-1 };
static gnutls_datum_t client_repro_key = { (void*)client_key_repro_pem, sizeof(client_key_repro_pem)-1 };
static gnutls_datum_t client_repro_cert = { (void*)client_cert_repro_pem, sizeof(client_cert_repro_pem)-1 };
