/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.mode;

import gnu.crypto.mode.IMode;
import gnu.crypto.mode.ModeFactory;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.HashMap;
import java.util.Map;

public class TestOfECB
implements Testlet {
    private byte[] key;
    private byte[] pt1;
    private byte[] ct1;
    private byte[] pt2;
    private byte[] ct2;
    private byte[] pt3;
    private byte[] ct3;
    private byte[] pt4;
    private byte[] ct4;
    private byte[] pt;
    private byte[] ct;
    private IMode mode;
    private Map attributes = new HashMap();

    public void test(TestHarness harness) {
        harness.checkPoint("TestOfECB.testAES128");
        this.key = Util.toBytesFromUnicode((String)"\u2b7e\u1516\u28ae\ud2a6\uabf7\u1588\u09cf\u4f3c");
        this.pt1 = Util.toBytesFromUnicode((String)"\u6bc1\ubee2\u2e40\u9f96\ue93d\u7e11\u7393\u172a");
        this.ct1 = Util.toBytesFromUnicode((String)"\u3ad7\u7bb4\u0d7a\u3660\ua89e\ucaf3\u2466\uef97");
        this.pt2 = Util.toBytesFromUnicode((String)"\uae2d\u8a57\u1e03\uac9c\u9eb7\u6fac\u45af\u8e51");
        this.ct2 = Util.toBytesFromUnicode((String)"\uf5d3\ud585\u03b9\u699d\ue785\u895a\u96fd\ubaaf");
        this.pt3 = Util.toBytesFromUnicode((String)"\u30c8\u1c46\ua35c\ue411\ue5fb\uc119\u1a0a\u52ef");
        this.ct3 = Util.toBytesFromUnicode((String)"\u43b1\ucd7f\u598e\uce23\u881b\u00e3\ued03\u0688");
        this.pt4 = Util.toBytesFromUnicode((String)"\uf69f\u2445\udf4f\u9b17\uad2b\u417b\ue66c\u3710");
        this.ct4 = Util.toBytesFromUnicode((String)"\u7b0c\u785e\u27e8\uad3f\u8223\u2071\u0472\u5dd4");
        this.ct = new byte[16];
        this.pt = new byte[16];
        this.mode = ModeFactory.getInstance((String)"ecb", (String)"aes", (int)16);
        this.attributes.clear();
        this.attributes.put("gnu.crypto.cipher.key.material", this.key);
        try {
            this.attributes.put("gnu.crypto.mode.state", new Integer(1));
            this.mode.init(this.attributes);
            this.mode.update(this.pt1, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct1), "ECB-AES128-Decrypt block #1");
            this.mode.update(this.pt2, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct2), "ECB-AES128-Decrypt block #2");
            this.mode.update(this.pt3, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct3), "ECB-AES128-Decrypt block #3");
            this.mode.update(this.pt4, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct4), "ECB-AES128-Decrypt block #4");
            this.mode.reset();
            this.attributes.put("gnu.crypto.mode.state", new Integer(2));
            this.mode.init(this.attributes);
            this.mode.update(this.ct1, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt1), "ECB-AES128-Decrypt block #1");
            this.mode.update(this.ct2, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt2), "ECB-AES128-Decrypt block #2");
            this.mode.update(this.ct3, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt3), "ECB-AES128-Decrypt block #3");
            this.mode.update(this.ct4, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt4), "ECB-AES128-Decrypt block #4");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfECB.testAES128");
        }
        harness.checkPoint("TestOfECB.testAES192");
        this.key = Util.toBytesFromUnicode((String)"\u8e73\ub0f7\uda0e\u6452\uc810\uf32b\u8090\u79e5\u62f8\uead2\u522c\u6b7b");
        this.pt1 = Util.toBytesFromUnicode((String)"\u6bc1\ubee2\u2e40\u9f96\ue93d\u7e11\u7393\u172a");
        this.ct1 = Util.toBytesFromUnicode((String)"\ubd33\u4f1d\u6e45\uf25f\uf712\ua214\u571f\ua5cc");
        this.pt2 = Util.toBytesFromUnicode((String)"\uae2d\u8a57\u1e03\uac9c\u9eb7\u6fac\u45af\u8e51");
        this.ct2 = Util.toBytesFromUnicode((String)"\u9741\u0484\u6d0a\ud3ad\u7734\uecb3\uecee\u4eef");
        this.pt3 = Util.toBytesFromUnicode((String)"\u30c8\u1c46\ua35c\ue411\ue5fb\uc119\u1a0a\u52ef");
        this.ct3 = Util.toBytesFromUnicode((String)"\uef7a\ufd22\u70e2\ue60a\udce0\uba2f\uace6\u444e");
        this.pt4 = Util.toBytesFromUnicode((String)"\uf69f\u2445\udf4f\u9b17\uad2b\u417b\ue66c\u3710");
        this.ct4 = Util.toBytesFromUnicode((String)"\u9a4b\u41ba\u738d\u6c72\ufb16\u6916\u03c1\u8e0e");
        this.ct = new byte[16];
        this.pt = new byte[16];
        this.mode = ModeFactory.getInstance((String)"ecb", (String)"aes", (int)16);
        this.attributes.clear();
        this.attributes.put("gnu.crypto.cipher.key.material", this.key);
        try {
            this.attributes.put("gnu.crypto.mode.state", new Integer(1));
            this.mode.init(this.attributes);
            this.mode.update(this.pt1, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct1), "ECB-AES192-Decrypt block #1");
            this.mode.update(this.pt2, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct2), "ECB-AES192-Decrypt block #2");
            this.mode.update(this.pt3, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct3), "ECB-AES192-Decrypt block #3");
            this.mode.update(this.pt4, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct4), "ECB-AES192-Decrypt block #4");
            this.mode.reset();
            this.attributes.put("gnu.crypto.mode.state", new Integer(2));
            this.mode.init(this.attributes);
            this.mode.update(this.ct1, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt1), "ECB-AES192-Decrypt block #1");
            this.mode.update(this.ct2, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt2), "ECB-AES192-Decrypt block #2");
            this.mode.update(this.ct3, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt3), "ECB-AES192-Decrypt block #3");
            this.mode.update(this.ct4, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt4), "ECB-AES192-Decrypt block #4");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfECB.testAES192");
        }
        harness.checkPoint("TestOfECB.testAES256");
        this.key = Util.toBytesFromUnicode((String)"\u603d\ueb10\u15ca\u71be\u2b73\uaef0\u857d\u7781\u1f35\u2c07\u3b61\u08d7\u2d98\u10a3\u0914\udff4");
        this.pt1 = Util.toBytesFromUnicode((String)"\u6bc1\ubee2\u2e40\u9f96\ue93d\u7e11\u7393\u172a");
        this.ct1 = Util.toBytesFromUnicode((String)"\uf3ee\ud1bd\ub5d2\ua03c\u064b\u5a7e\u3db1\u81f8");
        this.pt2 = Util.toBytesFromUnicode((String)"\uae2d\u8a57\u1e03\uac9c\u9eb7\u6fac\u45af\u8e51");
        this.ct2 = Util.toBytesFromUnicode((String)"\u591c\ucb10\ud410\ued26\udc5b\ua74a\u3136\u2870");
        this.pt3 = Util.toBytesFromUnicode((String)"\u30c8\u1c46\ua35c\ue411\ue5fb\uc119\u1a0a\u52ef");
        this.ct3 = Util.toBytesFromUnicode((String)"\ub6ed\u21b9\u9ca6\uf4f9\uf153\ue7b1\ubeaf\ued1d");
        this.pt4 = Util.toBytesFromUnicode((String)"\uf69f\u2445\udf4f\u9b17\uad2b\u417b\ue66c\u3710");
        this.ct4 = Util.toBytesFromUnicode((String)"\u2330\u4b7a\u39f9\uf3ff\u067d\u8d8f\u9e24\uecc7");
        this.ct = new byte[16];
        this.pt = new byte[16];
        this.mode = ModeFactory.getInstance((String)"ecb", (String)"aes", (int)16);
        this.attributes.clear();
        this.attributes.put("gnu.crypto.cipher.key.material", this.key);
        try {
            this.attributes.put("gnu.crypto.mode.state", new Integer(1));
            this.mode.init(this.attributes);
            this.mode.update(this.pt1, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct1), "ECB-AES256-Decrypt block #1");
            this.mode.update(this.pt2, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct2), "ECB-AES256-Decrypt block #2");
            this.mode.update(this.pt3, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct3), "ECB-AES256-Decrypt block #3");
            this.mode.update(this.pt4, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct4), "ECB-AES256-Decrypt block #4");
            this.mode.reset();
            this.attributes.put("gnu.crypto.mode.state", new Integer(2));
            this.mode.init(this.attributes);
            this.mode.update(this.ct1, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt1), "ECB-AES256-Decrypt block #1");
            this.mode.update(this.ct2, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt2), "ECB-AES256-Decrypt block #2");
            this.mode.update(this.ct3, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt3), "ECB-AES256-Decrypt block #3");
            this.mode.update(this.ct4, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt4), "ECB-AES256-Decrypt block #4");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfECB.testAES256");
        }
    }
}

