/*
 * Decompiled with CFR 0.152.
 */
package test.jce;

import gnu.crypto.jce.GnuCrypto;
import gnu.crypto.util.Prime;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOfKeyPairGenerator
extends TestCase {
    static /* synthetic */ Class class$test$jce$TestOfKeyPairGenerator;

    public TestOfKeyPairGenerator(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOfKeyPairGenerator.suite());
    }

    public static Test suite() {
        return new TestSuite(class$test$jce$TestOfKeyPairGenerator == null ? (class$test$jce$TestOfKeyPairGenerator = TestOfKeyPairGenerator.class$("test.jce.TestOfKeyPairGenerator")) : class$test$jce$TestOfKeyPairGenerator);
    }

    public void testUnknownGenerator() {
        try {
            KeyPairGenerator.getInstance("ABC", "GNU-CRYPTO");
            Assert.fail((String)"testUnknownGenerator()");
        }
        catch (Exception x) {
            Assert.assertTrue((String)"testUnknownGenerator()", (boolean)true);
        }
    }

    public void testDSAKeyPairGenerator() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("DSA", "GNU-CRYPTO");
        try {
            kpg.initialize(530);
            Assert.fail((String)"L should be <= 1024 and of the form 512 + 64n");
        }
        catch (IllegalArgumentException x) {
            Assert.assertTrue((String)"L should be <= 1024 and of the form 512 + 64n", (boolean)true);
        }
        kpg.initialize(576);
        KeyPair kp = kpg.generateKeyPair();
        BigInteger p1 = ((DSAPublicKey)kp.getPublic()).getParams().getP();
        BigInteger p2 = ((DSAPrivateKey)kp.getPrivate()).getParams().getP();
        Assert.assertTrue((String)"p1.equals(p2)", (boolean)p1.equals(p2));
        BigInteger q1 = ((DSAPublicKey)kp.getPublic()).getParams().getQ();
        BigInteger q2 = ((DSAPrivateKey)kp.getPrivate()).getParams().getQ();
        Assert.assertTrue((String)"q1.equals(q2)", (boolean)q1.equals(q2));
        BigInteger g1 = ((DSAPublicKey)kp.getPublic()).getParams().getG();
        BigInteger g2 = ((DSAPrivateKey)kp.getPrivate()).getParams().getG();
        Assert.assertTrue((String)"g1.equals(g2)", (boolean)g1.equals(g2));
        Assert.assertTrue((String)"q is probable prime", (boolean)Prime.isProbablePrime((BigInteger)q1, (boolean)true));
        Assert.assertTrue((String)"p is probable prime", (boolean)Prime.isProbablePrime((BigInteger)p1, (boolean)true));
    }

    public void testRSAKeyPairGenerator() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "GNU-CRYPTO");
        try {
            kpg.initialize(1023);
            Assert.fail((String)"L should be >= 1024");
        }
        catch (IllegalArgumentException x) {
            Assert.assertTrue((String)"L should be >= 1024", (boolean)true);
        }
        kpg.initialize(1024);
        KeyPair kp = kpg.generateKeyPair();
        BigInteger n1 = ((RSAPublicKey)kp.getPublic()).getModulus();
        BigInteger n2 = ((RSAPrivateKey)kp.getPrivate()).getModulus();
        BigInteger p = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeP();
        BigInteger q = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeQ();
        Assert.assertTrue((String)"n1 == pq", (boolean)n1.equals(p.multiply(q)));
        Assert.assertTrue((String)"n2 == pq", (boolean)n2.equals(p.multiply(q)));
    }

    protected void setUp() {
        Security.addProvider((Provider)new GnuCrypto());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

