/*
 * Decompiled with CFR 0.152.
 */
package test.sig.rsa;

import gnu.crypto.sig.rsa.RSA;
import gnu.crypto.sig.rsa.RSAKeyPairGenerator;
import gnu.crypto.util.Prime;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOfRSAKeyGeneration
extends TestCase {
    private static final BigInteger ZERO = BigInteger.ZERO;
    private static final BigInteger ONE = BigInteger.ONE;
    private RSAKeyPairGenerator kpg = new RSAKeyPairGenerator();
    private HashMap map = new HashMap();
    static /* synthetic */ Class class$test$sig$rsa$TestOfRSAKeyGeneration;

    public TestOfRSAKeyGeneration(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOfRSAKeyGeneration.suite());
    }

    public static Test suite() {
        return new TestSuite(class$test$sig$rsa$TestOfRSAKeyGeneration == null ? (class$test$sig$rsa$TestOfRSAKeyGeneration = TestOfRSAKeyGeneration.class$("test.sig.rsa.TestOfRSAKeyGeneration")) : class$test$sig$rsa$TestOfRSAKeyGeneration);
    }

    public void testKeyPairGeneration() {
        this.map.put("gnu.crypto.rsa.L", new Integer(530));
        try {
            this.kpg.setup((Map)this.map);
            Assert.fail((String)"L should be >= 1024");
        }
        catch (IllegalArgumentException x) {
            Assert.assertTrue((String)"L should be >= 1024", (boolean)true);
        }
        this.map.put("gnu.crypto.rsa.L", new Integer(1024));
        this.kpg.setup((Map)this.map);
        KeyPair kp = this.kpg.generate();
        BigInteger n1 = ((RSAPublicKey)kp.getPublic()).getModulus();
        BigInteger n2 = ((RSAPrivateKey)kp.getPrivate()).getModulus();
        BigInteger p = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeP();
        BigInteger q = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeQ();
        Assert.assertTrue((String)"n1 == pq", (boolean)n1.equals(p.multiply(q)));
        Assert.assertTrue((String)"n2 == pq", (boolean)n2.equals(p.multiply(q)));
    }

    public void testRSAParams() {
        this.map.put("gnu.crypto.rsa.L", new Integer(1024));
        this.kpg.setup((Map)this.map);
        KeyPair kp = this.kpg.generate();
        BigInteger n1 = ((RSAPublicKey)kp.getPublic()).getModulus();
        BigInteger e = ((RSAPublicKey)kp.getPublic()).getPublicExponent();
        BigInteger n2 = ((RSAPrivateKey)kp.getPrivate()).getModulus();
        BigInteger d = ((RSAPrivateKey)kp.getPrivate()).getPrivateExponent();
        BigInteger p = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeP();
        BigInteger q = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeQ();
        BigInteger dP = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeExponentP();
        BigInteger dQ = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeExponentQ();
        BigInteger qInv = ((RSAPrivateCrtKey)kp.getPrivate()).getCrtCoefficient();
        Assert.assertTrue((String)"n1 is a 1024-bit MPI", (n1.bitLength() == 1024 ? 1 : 0) != 0);
        Assert.assertTrue((String)"n2 is a 1024-bit MPI", (n2.bitLength() == 1024 ? 1 : 0) != 0);
        Assert.assertTrue((String)"n1 == n2", (boolean)n1.equals(n2));
        Assert.assertTrue((String)"p is prime", (boolean)Prime.isProbablePrime((BigInteger)p, (boolean)true));
        Assert.assertTrue((String)"q is prime", (boolean)Prime.isProbablePrime((BigInteger)q, (boolean)true));
        Assert.assertTrue((String)"n == pq", (boolean)n1.equals(p.multiply(q)));
        BigInteger p_minus_1 = p.subtract(ONE);
        BigInteger q_minus_1 = q.subtract(ONE);
        Assert.assertTrue((String)"0 < dP < p-1", (ZERO.compareTo(dP) < 0 && dP.compareTo(p_minus_1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"0 < dQ < q-1", (ZERO.compareTo(dQ) < 0 && dQ.compareTo(q_minus_1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"e.dP == 1 (mod p-1)", (boolean)e.multiply(dP).mod(p_minus_1).equals(ONE));
        Assert.assertTrue((String)"e.dQ == 1 (mod q-1)", (boolean)e.multiply(dQ).mod(q_minus_1).equals(ONE));
        Assert.assertTrue((String)"q.qInv == 1 (mod p)", (boolean)q.multiply(qInv).mod(p).equals(ONE));
        BigInteger phi = p_minus_1.multiply(q_minus_1);
        Assert.assertTrue((String)"gcd(e, phi) == 1", (boolean)e.gcd(phi).equals(ONE));
        Assert.assertTrue((String)"e.d == 1 (mod phi)", (boolean)e.multiply(d).mod(phi).equals(ONE));
    }

    public void testRSAPrimitives() {
        this.map.put("gnu.crypto.rsa.L", new Integer(1024));
        this.kpg.setup((Map)this.map);
        KeyPair kp = this.kpg.generate();
        PublicKey pubK = kp.getPublic();
        PrivateKey privK = kp.getPrivate();
        BigInteger n = ((RSAPublicKey)pubK).getModulus();
        BigInteger m = ZERO;
        Random prng = new Random(System.currentTimeMillis());
        while (m.equals(ZERO) || m.compareTo(n) >= 0) {
            m = new BigInteger(1024, prng);
        }
        BigInteger s = RSA.sign((PrivateKey)privK, (BigInteger)m);
        BigInteger cm = RSA.verify((PublicKey)pubK, (BigInteger)s);
        Assert.assertTrue((String)"cm == m", (boolean)cm.equals(m));
    }

    protected void setUp() {
        this.kpg = new RSAKeyPairGenerator();
        this.map = new HashMap();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

