/*
  Licensed under the GNU Public License.
  Copyright (C) 1998-99 by Thomas M. Vier, Jr. All Rights Reserved.

  wipe is free software.
  See LICENSE for more information.
*/

/* just in case anything else includes wipe.h */
#include <config.h>

/* conditional includes */

#ifdef HAVE_ASM_TYPES
# include <asm/types.h>
#else
typedef unsigned char __u8;
typedef unsigned short __u16;
typedef unsigned int __u32;
typedef unsigned long long __u64;
#endif

/* typedef stuff */
#undef PWORD
#define PWORD __u32

#ifdef __alpha__
# undef PWORD
# define PWORD __u64
#endif

#ifdef __sparc64__
# undef PWORD
# define PWORD __u64
#endif

typedef PWORD _pword;

#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#else
# undef HAVE_FCNTL
#endif

#ifndef HAVE_FCNTL
# ifndef HAVE_LOCKF
#  ifdef HAVE_FLOCK
#   ifdef HAVE_SYS_FILE_H
#    include <sys/file.h>
#   else
#    undef HAVE_FLOCK
#   endif
#  endif
# endif
#endif

#ifdef HAVE_GETOPT_H
# include <getopt.h>
#endif

#ifdef HAVE_DIRENT_H
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NAMLEN(dirent) (dirent)->d_namlen)
# ifdef HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# ifdef HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# ifdef HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif

#ifndef PATH_MAX
# define PATH_MAX 1024
#endif

/* conditional defines */

#ifdef STAT_MACROS_BROKEN
/* just in case, so we don't unlink a directory,
   we don't currently handle broken stat macros */
# define unlink(x) remove(x)
#endif

#ifndef HAVE_UNLINK
# define unlink(x) remove(x)
#endif

#ifndef HAVE_RMDIR
# define rmdir(x) remove(x)
#endif

#undef SYNC
#ifdef HAVE_FDATASYNC
# define SYNC

/* for some reason, this proto is needed for glibc2, even though
 * it's already in unistd.h, cuz for some reason, it wasn't being
 * properly included
 */
extern int fdatasync  (int __fildes)    ; /* copied from unistd.h */

#elif HAVE_FSYNC
# define SYNC
#endif

#ifdef SYNC
# ifndef HAVE_FDATASYNC
#  ifdef HAVE_FSYNC
#   define fdatasync(fd) fsync(fd)
#  endif
# endif
#endif

#undef LOCKABLE
#ifdef HAVE_FCNTL
# define LOCKABLE
#elif HAVE_LOCKF
# define LOCKABLE
#elif HAVE_FLOCK
# define LOCKABLE
#endif

/* structs */

/* percent data */
struct complete
{
  float complete;               /* percentage of wipe completion             */
  float increment;              /* add to percentage after each pass         */
  unsigned int display:1;       /* show percentage                           */
  unsigned int reported:1;      /* set if percentage was reported            */
};

/* command line options */
struct opt
{
  unsigned int hash:1;          /* use /dev/urandom hash if true             */
  unsigned int verbose:2;       /* verbose level                             */
  unsigned int recursion:1;     /* traverse directories if true              */
  unsigned int zero:1;          /* zero-out file                             */
  unsigned int force:1;         /* force wipes -- override interaction       */
  unsigned int delete:1;        /* remove targets if true                    */
  unsigned int custom:1;        /* wipe file with user specified byte        */
  unsigned int random:1;        /* perform random passes if true             */
  unsigned int seclevel:2;      /* secure level                              */
  unsigned int interactive:1;   /* prompt for each file                      */
  unsigned int random_loop:5;   /* how many times to loop the random passes  */
  unsigned int wipe_multiply:5; /* how many times to loop all 35 passes      */
};

/* prototypes */

#ifdef LOCKABLE
int lock(void);
#endif

void help(int code, FILE *out);
void badopt(int c);
void show_copy(void);
void show_war(void);

void percent_init(void);

char gettrn_char(void);
int init_hashin(void);
void hashin_update(void);
void hashout_update(void);

void random_pass(int passes);
void random_pass_raw(int passes);
void write_pass(const unsigned char wipe_byte);
void write3_pass(const unsigned char wipe_byte1, const unsigned char wipe_byte2, const unsigned char wipe_byte3);

char rand_safe_char(void);
int wipename(void);

int destroy(char file[]);
int zero(void);
int wipe(void);

int getfiledata(char *file);
int drilldown(const char str[]);
int direntcheck(const char str[]);
int checkfile(char file[]);

int main(int argc, char **argv);
