unit SetupEnt;

{
  Inno Setup
  Copyright (C) 1998-99 Jordan Russell
  For conditions of distribution and use, see LICENSE.TXT.

  Functions for handling records with embedded long strings
}

interface

uses
  zlib;

procedure SEFreeRec (const P: Pointer; const NumStrings: Integer);
procedure SEDuplicateRec (OldP, NewP: Pointer; Bytes: Cardinal;
  const NumStrings: Integer);
procedure SEDeflateBlockWrite (var Data: TDeflateBlockWriteData; var Buf;
  const Count: Cardinal; const NumStrings: Integer);
procedure SEInflateBlockRead (var Data: TDeflateBlockReadData; var Buf;
  const Count: Cardinal; const NumStrings: Integer);

implementation

procedure SEFreeRec (const P: Pointer; const NumStrings: Integer);
begin
  if P = nil then Exit;
  if NumStrings > 0 then  { Finalize in Delphi versions < 5 can't be called with zero count }
    Finalize (String(P^), NumStrings);
  FreeMem (P);
end;

procedure SEDuplicateRec (OldP, NewP: Pointer; Bytes: Cardinal;
  const NumStrings: Integer);
var
  I: Integer;
begin
  for I := 1 to NumStrings do begin
    String(NewP^) := String(OldP^);
    Inc (Cardinal(OldP), SizeOf(Pointer));
    Inc (Cardinal(NewP), SizeOf(Pointer));
    Dec (Bytes, SizeOf(Pointer));
  end;
  Move (OldP^, NewP^, Bytes);
end;

procedure SEDeflateBlockWrite (var Data: TDeflateBlockWriteData; var Buf;
  const Count: Cardinal; const NumStrings: Integer);
var
  P: Pointer;
  I: Integer;
  Len: Integer;
begin
  P := @Buf;
  for I := 1 to NumStrings do begin
    Len := Length(String(P^));
    DeflateBlockWrite (Data, Len, SizeOf(Len));
    if Len <> 0 then
      DeflateBlockWrite (Data, Pointer(P^)^, Len);
    Inc (Cardinal(P), SizeOf(Pointer));
  end;
  DeflateBlockWrite (Data, P^, Count - (Cardinal(NumStrings) * SizeOf(Pointer)));
end;

procedure SEInflateBlockRead (var Data: TDeflateBlockReadData; var Buf;
  const Count: Cardinal; const NumStrings: Integer);
var
  P: Pointer;
  I: Integer;
  Len: Integer;
  S: String;
begin
  P := @Buf;
  for I := 1 to NumStrings do begin
    InflateBlockRead (Data, Len, SizeOf(Len));
    SetLength (S, Len);
    if Len <> 0 then
      InflateBlockRead (Data, S[1], Len);
    String(P^) := S;
    Inc (Cardinal(P), SizeOf(Pointer));
  end;
  InflateBlockRead (Data, P^, Count - (Cardinal(NumStrings) * SizeOf(Pointer)));
end;

end.

