unit CompOptions;

{
  Inno Setup
  Copyright (C) 1998-2000 Jordan Russell
  For conditions of distribution and use, see LICENSE.TXT.

  Compiler Options form
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TOptionsForm = class(TForm)
    OKButton: TButton;
    CancelButton: TButton;
    GroupBox1: TGroupBox;
    TestCheck: TCheckBox;
    BackupCheck: TCheckBox;
    GroupBox2: TGroupBox;
    AssocButton: TButton;
    procedure AssocButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation

uses
  ShlObj;

{$R *.DFM}

procedure TOptionsForm.AssocButtonClick(Sender: TObject);
var
  K: HKEY;

  procedure Check (const Res: Longint);
  begin
    if Res <> ERROR_SUCCESS then
      raise Exception.CreateFmt('Error creating file association:'#13#10'%d - %s',
        [Res, SysErrorMessage(Res)]);
  end;

  procedure OpenKey (const Subkey: PChar);
  var
    Disp: DWORD;
  begin
    Check (RegCreateKeyEx(HKEY_CLASSES_ROOT, Subkey, 0, nil, 0, KEY_SET_VALUE,
      nil, K, @Disp));
  end;

  procedure CloseKey;
  begin
    if K <> 0 then begin
      RegCloseKey(K);
      K := 0;
    end;
  end;

  procedure SetStringValue (const ValueName: PChar; const Data: String);
  begin
    Check (RegSetValueEx(K, '', 0, REG_SZ, PChar(Data), Length(Data)+1));
  end;

var
  SelfName: String;
begin
  SelfName := ParamStr(0);
  K := 0;
  try
    OpenKey ('.iss');
    SetStringValue ('', 'InnoSetupScriptFile');
    CloseKey;

    OpenKey ('InnoSetupScriptFile');
    SetStringValue ('', 'Inno Setup Script');
    CloseKey;

    OpenKey ('InnoSetupScriptFile\DefaultIcon');
    SetStringValue ('', SelfName + ',1');
    CloseKey;

    OpenKey ('InnoSetupScriptFile\shell\open\command');
    SetStringValue ('', '"' + SelfName + '" "%1"');
    CloseKey;

    OpenKey ('InnoSetupScriptFile\shell\OpenWithInnoSetup');
    SetStringValue ('', 'Open with &Inno Setup');
    CloseKey;

    OpenKey ('InnoSetupScriptFile\shell\OpenWithInnoSetup\command');
    SetStringValue ('', '"' + SelfName + '" "%1"');
    CloseKey;

    OpenKey ('InnoSetupScriptFile\shell\Compile');
    SetStringValue ('', 'Compi&le');
    CloseKey;

    OpenKey ('InnoSetupScriptFile\shell\Compile\command');
    SetStringValue ('', '"' + SelfName + '" /cc "%1"');
  finally
    CloseKey;
  end;
  SHChangeNotify (SHCNE_ASSOCCHANGED, SHCNF_IDLIST, nil, nil);
  Application.MessageBox (PChar('The .iss extension was successfully ' +
    'associated with:'#13#10 + SelfName), 'Associate',
    MB_OK or MB_ICONINFORMATION);
end;

end.
